/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.websm.invscout;

import com.ibm.hsc.auiml.databeans.invscout.iscmainB;
import com.ibm.hsc.auiml.databeans.invscout.iscmainPartitionConfig;
import com.ibm.hsc.auiml.databeans.invscout.iscrestartB;
import com.ibm.hsc.auiml.databeans.invscout.iscucodeB;
import com.ibm.hsc.auiml.databeans.invscout.iscvpdB;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.util.CECInfo;
import com.ibm.hsc.common.util.CIMUtils;
import com.ibm.hsc.common.util.Trace;
import com.ibm.websm.etc.EExec;
import com.ibm.websm.etc.EExecResult;
import com.ibm.websm.mobject.MOXReference;
import com.ibm.websm.mobject.MObjectImpl;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class InvScoutOverview
extends MObjectImpl {
    private static final String TRACE_MASKD = "JINSCOVD";
    private static final String TRACE_MASKF = "JINSCOVF";
    private static final String TRACE_MASKT = "JINSCOVT";
    public static final String SWITCH_NETWORK_ID = HSCResourceBundleUtil.getMessage("SFPResourceBundle", "SWITCH_NETWORK_ID", "Switch Network ID:");
    public static final String I_STUB_CMD = "/opt/hsc/bin/i_stub_FS";

    public InvScoutOverview(String string) throws Throwable {
        Trace.trace(TRACE_MASKT, "-> InvScoutOverview.InvScoutOverview()");
        this.setKey(string);
        Trace.trace(TRACE_MASKT, "<- InvScoutOverview.InvScoutOverview()");
    }

    public static String getClassName() {
        Trace.trace(TRACE_MASKT, "-> InvScoutOverview.getClassName()");
        Trace.trace(TRACE_MASKT, "<- InvScoutOverview.getClassName()");
        return "InventoryScoutOverview";
    }

    public static MObjectImpl getInstance(MOXReference mOXReference) throws Throwable {
        Trace.trace(TRACE_MASKT, "-> InvScoutOverview.getInstance()");
        String string = mOXReference.getKey();
        InvScoutOverview invScoutOverview = new InvScoutOverview(string);
        Trace.trace(TRACE_MASKT, "<- InvScoutOverview.getInstance()");
        return invScoutOverview;
    }

    public static void iscucodeSaveDataW(String string) throws Throwable {
        iscucodeB.saveData(string);
    }

    public static void iscvpdSaveDataW(String string) throws Throwable {
        iscvpdB.saveData(string);
    }

    public static Vector iscmainReadProfileW(String string, Vector vector, Vector vector2, Vector vector3, Vector vector4) throws Throwable {
        Vector vector5 = new Vector();
        vector5 = iscmainB.readProfile(string, vector, vector2, vector3, vector4);
        return vector5;
    }

    public static void iscmainCommitWorkingDataW(String string, Vector vector, Vector vector2, Vector vector3, Vector vector4) throws Throwable {
        iscmainB.commitWorkingData(string, vector, vector2, vector3, vector4);
    }

    public static Vector iscucodeCommandW(String string) throws Throwable {
        Vector vector = iscucodeB.iscucodeCommand(string);
        return vector;
    }

    public static Vector iscvpdCommandW(String string) throws Throwable {
        Vector vector = iscvpdB.iscvpdCommand(string);
        return vector;
    }

    public static Vector ListAllCECsW() throws Throwable {
        Vector<String> vector = new Vector<String>();
        Vector vector2 = null;
        CECInfo cECInfo = null;
        Trace.trace(TRACE_MASKT, "-> InvScoutOverview.listAllCECsW()");
        try {
            Enumeration enumeration;
            vector2 = CIMUtils.getCECsInfo();
            if (vector2 != null && vector2.size() > 0) {
                Trace.trace(TRACE_MASKF, "tempVector size is " + vector2.size());
            } else {
                Trace.trace(TRACE_MASKF, "getCECsInfo() returned a vector of size 0, or vector is null");
            }
            if (vector2 != null && vector2.size() > 0) {
                enumeration = vector2.elements();
                while (enumeration.hasMoreElements()) {
                    cECInfo = (CECInfo)enumeration.nextElement();
                    Trace.trace(TRACE_MASKF, "model type is " + cECInfo.getCECModelType());
                    Trace.trace(TRACE_MASKF, "serial nunmber is " + cECInfo.getCECSerialNumber());
                    Trace.trace(TRACE_MASKF, "machine name is " + cECInfo.getCECMachineName());
                    vector.addElement(cECInfo.getCECModelType() + "_" + cECInfo.getCECSerialNumber() + "          " + cECInfo.getCECMachineName());
                }
            }
            if (vector != null) {
                Trace.trace(TRACE_MASKD, "getCECsInfo() found the following CECs:");
                enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    Trace.trace(TRACE_MASKD, "CEC found of " + (String)enumeration.nextElement());
                }
            } else {
                Trace.trace(TRACE_MASKD, "getCECsInfo returned null");
            }
        }
        catch (Throwable throwable) {
            Trace.trace(TRACE_MASKT, "-- InvScoutOverview.listAllCECsW() exception is " + throwable);
        }
        Trace.trace(TRACE_MASKT, "<- InvScoutOverview.listAllCECsW()");
        return vector;
    }

    public static Vector ListAllSwitchNetworksW() throws Throwable {
        Vector<String> vector = new Vector<String>();
        EExecResult eExecResult = null;
        Trace.trace(TRACE_MASKT, "-> InvScoutOverview.ListAllSwitchNetworksW()");
        try {
            String string = "/opt/hsc/bin/i_stub_FS dump -n";
            Trace.trace(TRACE_MASKT, "-- about to issue cmd <" + string + ">");
            eExecResult = EExec.Exec((String)string);
            if (eExecResult.rc == 0) {
                Trace.trace(TRACE_MASKF, "-- cmd request successful");
                Trace.trace(TRACE_MASKF, "-- data returned is <" + eExecResult.stdout + ">");
                if (eExecResult.stdout != null) {
                    StringReader stringReader = new StringReader(eExecResult.stdout.trim());
                    BufferedReader bufferedReader = new BufferedReader(stringReader);
                    String string2 = null;
                    while ((string2 = bufferedReader.readLine()) != null) {
                        Trace.trace(TRACE_MASKF, "-- stdout line read is <" + string2 + ">");
                        StringTokenizer stringTokenizer = new StringTokenizer(string2.trim());
                        String string3 = stringTokenizer.nextToken();
                        String string4 = SWITCH_NETWORK_ID + " " + string3;
                        vector.addElement(string4);
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "-- <" + string + "> cmd worked, but returned data is null");
                }
            } else {
                Trace.trace(TRACE_MASKF, "-- cmd (i_stub_FS) request failed, rc = " + eExecResult.rc);
                Trace.trace(TRACE_MASKF, "-- cmd execResult.stderr is <" + eExecResult.stderr.trim() + ">");
            }
        }
        catch (Exception exception) {
            Trace.trace(TRACE_MASKF, "-- InvScoutOverview.ListAllSwitchNetworksW() exception is " + exception);
        }
        Trace.trace(TRACE_MASKT, "<- InvScoutOverview.ListAllSwitchNetworksW()");
        return vector;
    }

    public static Vector ListPartitionUserNamesW(String string, String string2) throws Throwable {
        Vector vector = null;
        Trace.trace(TRACE_MASKT, "-> InvScoutOverview.ListPartitionUserNamesW()");
        try {
            vector = CIMUtils.getPartitions(string, string2);
        }
        catch (Throwable throwable) {
            Trace.trace(TRACE_MASKT, "-- InvScoutOverview.ListPartitionUserNamesW() exception is " + throwable);
        }
        Trace.trace(TRACE_MASKT, "<- InvScoutOverview.ListPartitionUserNamesW()");
        return vector;
    }

    public static Vector ListPartitionNamesW(String string, String string2) throws Throwable {
        Vector vector = null;
        Trace.trace(TRACE_MASKT, "-> InvScoutOverview.ListPartitionNamesW()");
        try {
            vector = CIMUtils.getPartitionKeyNames(string, string2);
        }
        catch (Throwable throwable) {
            Trace.trace(TRACE_MASKT, "-- InvScoutOverview.ListPartitionNamesW() exception is " + throwable);
        }
        Trace.trace(TRACE_MASKT, "<- InvScoutOverview.ListPartitionNamesW()");
        return vector;
    }

    public static String issueLshscCmdW(String string) throws Throwable {
        String string2 = null;
        string2 = iscmainPartitionConfig.issueLshscCmd(string);
        return string2;
    }

    public static void restartInvScoutW() throws Throwable {
        iscrestartB.restartInvScout();
    }
}

